/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model;

import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.lib.model.baked.BakedModelBuilder;
import dev.engine_room.flywheel.lib.model.baked.BlockModelBuilder;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.util.RendererReloadCache;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4587;

public final class Models {
    private static final RendererReloadCache<class_2680, Model> BLOCK_STATE = new RendererReloadCache<class_2680, Model>(it -> BlockModelBuilder.create(SinglePosVirtualBlockGetter.createFullDark().blockState((class_2680)it), List.of(class_2338.field_10980)).build());
    private static final RendererReloadCache<PartialModel, Model> PARTIAL = new RendererReloadCache<PartialModel, Model>(it -> BakedModelBuilder.create(it.get()).build());
    private static final RendererReloadCache<TransformedPartial<?>, Model> TRANSFORMED_PARTIAL = new RendererReloadCache<TransformedPartial, Model>(TransformedPartial::create);

    private Models() {
    }

    public static Model block(class_2680 state) {
        return BLOCK_STATE.get(state);
    }

    public static Model partial(PartialModel partial) {
        return PARTIAL.get(partial);
    }

    public static <T> Model partial(PartialModel partial, T key, BiConsumer<T, class_4587> transformer) {
        return TRANSFORMED_PARTIAL.get(new TransformedPartial<T>(partial, key, transformer));
    }

    public static Model partial(PartialModel partial, class_2350 dir) {
        return Models.partial(partial, dir, Models::rotateAboutCenterToFace);
    }

    private static void rotateAboutCenterToFace(class_2350 facing, class_4587 stack) {
        ((PoseTransformStack)((PoseTransformStack)TransformStack.of(stack).center()).rotateToFace(facing.method_10153())).uncenter();
    }

    private record TransformedPartial<T>(PartialModel partial, T key, BiConsumer<T, class_4587> transformer) {
        private Model create() {
            class_4587 stack = new class_4587();
            this.transformer.accept(this.key, stack);
            return BakedModelBuilder.create(this.partial.get()).poseStack(stack).build();
        }
    }
}

